/* $Id: fft.c,v 1.6 1998/07/20 23:37:06 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Keith Bayern */

/***************************************************************************

This example requires the E1432 to be at Logical Address 8.  You can
change the resource string in the hpe1432_init call if you want to
change the address.

The output of this program is a list of BLOCK_SIZE/2 numbers which are
the RMS^2 points of the fft from the DC bin to fs/2-1.

With a small amount of work, one could enable the time data and read
both time and frequency.

****************************************************************************/

#define CHK \
    if(vierr)\
    {\
        hpe1432_error_message(session,vierr,st);\
        hpe1432_errorDetails(session,details,100);\
        printf("error %d = %s, line %d\nDetails: %s\n",vierr,st,__LINE__,details);\
        exit(0);\
    }

#include <stdio.h>
#include <stdlib.h>

#include "hpe1432.h"

#define BLOCK_SIZE 512

void main()
{
ViSession	session;
ViInt32		channels[10];
ViInt32		gid;
ViReal64	data[BLOCK_SIZE];
char		st[100];
char		details[100];
ViInt32		actualCount;
ViInt32		i;
ViInt32		flag;
ViStatus	vierr;

    /* initialize instrument  This code ASSUMES hpe1432 at address 8 */
    vierr=hpe1432_init("VXI0::8::INSTR",0,1,&session);
    CHK

    /* make an array of input channel numbers (only one in this simple demo) */
    channels[0]=1;

    vierr=hpe1432_deleteAllChanGroups(session);
    CHK

    vierr=hpe1432_createChannelGroup(session,1,channels,&gid);
    CHK

    /* set the fifo blocksize */
    vierr=hpe1432_setBlocksize(session,gid,BLOCK_SIZE);
    CHK

    vierr=hpe1432_setDataMode(session,gid,HPE1432_BLOCK_MODE);
    CHK

    vierr=hpe1432_setWindow(session,gid,HPE1432_WINDOW_HANNING);
    CHK

    vierr=hpe1432_setCalcData(session,gid,HPE1432_DATA_FREQ);
    CHK

    vierr=hpe1432_setEnable(session,gid,HPE1432_ENABLE_TYPE_TIME,
			    HPE1432_ENABLE_OFF);
    CHK

    vierr=hpe1432_setEnable(session,gid,HPE1432_ENABLE_TYPE_FREQ,
			    HPE1432_ENABLE_ON);
    CHK

    vierr = hpe1432_setAvgMode(session, gid, HPE1432_AVG_RMS);
    CHK

    vierr = hpe1432_setAvgNumber(session, gid, 1);
    CHK

    vierr = hpe1432_setAvgUpdate(session, gid, 1);
    CHK

    vierr = hpe1432_setAvgWeight(session, gid, 1);
    CHK

    vierr=hpe1432_initMeasure(session,gid);
    CHK

    flag=0;
    while (!flag)
    {
        vierr=hpe1432_blockAvailable(session,gid,&flag);
        CHK
    }
#if 0
    /* wait for the data and then read it */
    vierr=hpe1432_readFloat64Data(session,gid,
                                  HPE1432_TIME_DATA,
                                  data,
                                  BLOCK_SIZE,
                                  &actualCount,
                                  HPE1432_WAIT_FLAG);

    CHK

    /* print the time data */
    printf("--TIME--\n");
    for(i=0;i<BLOCK_SIZE;i++)
		printf("%lf\n",data[i]);

#endif

    flag=0;
    while (!flag)
    {
        vierr=hpe1432_blockAvailable(session,gid,&flag);
        CHK
    }

    /* wait for the data and then read it */
    vierr=hpe1432_readFloat64Data(session,gid,
                                  HPE1432_FREQ_DATA,
                                  data,
                                  BLOCK_SIZE/2,
                                  &actualCount,
                                  HPE1432_NO_WAIT_FLAG);


    CHK
    /* print the data */
    for(i=0;i<BLOCK_SIZE/2;i++)
		printf("%lf\n",data[i]);


    
}

